# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from django.db import migrations, models


class Migration(migrations.Migration):

    dependencies = [
        ('core', '0052_add_two_currencies'),
    ]

    operations = [
        migrations.AddField(
            model_name='protocol',
            name='financial_report_file',
            field=models.BinaryField(null=True, blank=True),
        ),
        migrations.AddField(
            model_name='protocol',
            name='protocol_file',
            field=models.BinaryField(null=True, blank=True),
        ),
        migrations.AddField(
            model_name='protocol',
            name='ticket_document',
            field=models.CharField(max_length=32, blank=True),
        ),
        migrations.AddField(
            model_name='protocol',
            name='ticket_kaznaops',
            field=models.CharField(max_length=32, blank=True),
        ),
        migrations.AlterField(
            model_name='protocol',
            name='staff_login',
            field=models.CharField(max_length=30, null=True),
        ),
        migrations.AlterField(
            model_name='protocol',
            name='staff_uid',
            field=models.BigIntegerField(null=True),
        ),
        migrations.RunSQL(
            "CREATE UNIQUE INDEX unique_chairman ON core_responsible (role) WHERE (role = 'infosec_chairman');",
            "DROP INDEX unique_chairman;",
        ),
    ]
